/*
 * Decompiled with CFR 0.152.
 */
package com.technicalitiesmc.lib.inventory;

import com.technicalitiesmc.lib.inventory.InventoryHint;
import com.technicalitiesmc.lib.util.AbstractFlags8;
import java.util.IdentityHashMap;
import java.util.Map;
import net.minecraftforge.items.IItemHandler;

public class InventoryHintFlags
extends AbstractFlags8<InventoryHint, InventoryHintFlags> {
    private static final InventoryHintFlags NONE = new InventoryHintFlags(0);
    private static final InventoryHintFlags ALL = new InventoryHintFlags((byte)((1 << InventoryHint.values().length) - 1));
    private static final Map<Class<? extends IItemHandler>, InventoryHintFlags> HINTS = new IdentityHashMap<Class<? extends IItemHandler>, InventoryHintFlags>();

    public static InventoryHintFlags none() {
        return NONE;
    }

    public static InventoryHintFlags all() {
        return ALL;
    }

    public static InventoryHintFlags of(InventoryHint ... hints) {
        return new InventoryHintFlags(InventoryHintFlags.makeMask(hints));
    }

    public static InventoryHintFlags deserialize(byte value) {
        return new InventoryHintFlags(value);
    }

    public static InventoryHintFlags of(Class<? extends IItemHandler> type) {
        return HINTS.computeIfAbsent(type, $ -> InventoryHintFlags.none());
    }

    public static InventoryHintFlags of(IItemHandler inventory) {
        return InventoryHintFlags.of(inventory.getClass());
    }

    public static void add(Class<? extends IItemHandler> type, InventoryHint ... hints) {
        InventoryHintFlags current = InventoryHintFlags.of(type);
        HINTS.put(type, (InventoryHintFlags)current.and(hints));
    }

    private InventoryHintFlags(byte value) {
        super(value);
    }

    @Override
    protected Class<InventoryHint> getType() {
        return InventoryHint.class;
    }

    @Override
    protected InventoryHintFlags create(byte value) {
        return new InventoryHintFlags(value);
    }
}

